#include "xfms.h"

int TestFunction(COOLINFO *ci, int i, DWORD dw)
{
 	return (int)(*ci->lpTestFunction)(i,dw);
}

int ReadData(COOLINFO *ci, char huge *data, long offset, long amount)
{
 	return (int)(*ci->lpReadData)(data,offset,amount);
}

int WriteData(COOLINFO *ci, char huge *data, long offset, long amount)
{
 	return (int)(*ci->lpWriteData)(data,offset,amount);
}
            
int CutData(COOLINFO *ci, DWORD dwOffset, DWORD dwBytes)
{
 	return (int)(*ci->lpCutData)(dwOffset,dwBytes);
}   

int InsertBlankData(COOLINFO *ci, DWORD dwOffset, DWORD dwBytes)
{	
	return (int)(*ci->lpInsertBlankData)(dwOffset,dwBytes);
}         
            
void DelayWriteInit(COOLINFO *ci, unsigned int uiSize, long lOffset, long lLength)
{
 	(*ci->lpDelayWriteInit)(uiSize, lOffset, lLength);
 	return;
}

void DelayWriteDestroy(COOLINFO *ci)
{
 	(*ci->lpDelayWriteDestroy)();
 	return;
}          

void DelayWrite(COOLINFO *ci, char far *data,unsigned int uiBytes)
{	(*ci->lpDelayWrite)(data, uiBytes);
	return;
}

BOOL ProgressMeter(COOLINFO *ci, DWORD dwCurrent, DWORD dwTotal)
{
 	return (BOOL)(*ci->lpProgressMeter)(dwCurrent, dwTotal);
}                                                           

void ProgressCreate(COOLINFO *ci, LPCSTR szText, HWND hWndParent)
{
 	(*ci->lpProgressCreate)(szText, hWndParent);
}                                   

void ProgressDestroy(COOLINFO *ci)
{
 	(*ci->lpProgressDestroy)();
}

void CenterDialog(COOLINFO *ci, HWND hWndDlg)
{
 	(*ci->lpCenterDialog)(hWndDlg,0);
}

BOOL PresetsInit(COOLINFO FAR *ci, HWND hWndDlg, LPCSTR szGroupName)
{
	return (*ci->lpPresetsInit)(hWndDlg, szGroupName, ci->szIniFile);
}

BOOL HandleID_PRESETS(COOLINFO FAR *ci, HWND hWndDlg, LPCSTR szGroupName, LONG lParam)
{
 	return (*ci->lpHandleID_PRESETS)(ci, hWndDlg, szGroupName, lParam);
}

void HandleID_ADD(COOLINFO FAR *ci, HWND hWndDlg, LPCSTR szGroupName)
{
 	(*ci->lpHandleID_ADD)(ci, hWndDlg, szGroupName);
}   

void HandleID_DEL(COOLINFO FAR *ci, HWND hWndDlg, LPCSTR szGroupName)
{
 	(*ci->lpHandleID_DEL)(hWndDlg, szGroupName);
}

void HandleID_PRESETNAME(COOLINFO FAR *ci, HWND hWndDlg)
{   
	(*ci->lpHandleID_PRESETNAME)(hWndDlg);
}
              
HANDLE GraphCreate(COOLINFO FAR *ci, int left, int right, 
				   int min, int max, int leftval, int rightval)
{	
	return (HANDLE)(*ci->lpGraphCreate)(left,right,min,max,leftval,rightval);
}   

void GraphSetDialog(COOLINFO FAR *ci, HANDLE hGraph, HWND hWndDlg, UINT uiControl, UINT uiDisplay)
{
 	(*ci->lpGraphSetDialog)(hGraph, hWndDlg, uiControl, uiDisplay);
}

int GraphCount(COOLINFO FAR *ci, HANDLE hGraph)
{
 	return (int)(*ci->lpGraphCount)(hGraph);
}          

POINT GraphGetPoint(COOLINFO FAR *ci, HANDLE hGraph, int iIndex)
{   POINT point;
 	(*ci->lpGraphGetPoint)(hGraph, iIndex, (POINT FAR *)&point);
 	return point;
}

void GraphSetPoint(COOLINFO FAR *ci, HANDLE hGraph, int iWhich, POINT point, BOOL bEndPoint)
{	
	(*ci->lpGraphSetPoint)(hGraph,iWhich,point,bEndPoint);
}

double GraphGetValueAt(COOLINFO FAR *ci, HANDLE hGraph, double xvalue)
{   double y;
 	(*ci->lpGraphGetValueAt)(hGraph, xvalue, (double far *)&y);
 	return y;
}

void GraphDraw(COOLINFO FAR *ci, HANDLE hGraph, HDC hDC)
{
 	(*ci->lpGraphDraw)(hGraph, hDC);
}

void GraphClear(COOLINFO FAR *ci, HANDLE hGraph)
{
	(*ci->lpGraphClear)(hGraph);
}

void GraphCopy(COOLINFO FAR *ci, HANDLE hDest, HANDLE hSrc)
{
	(*ci->lpGraphCopy)(hDest,hSrc);
}

void GraphInverse(COOLINFO FAR *ci, HANDLE hGraph)
{
	(*ci->lpGraphInverse)(hGraph);
}

void GraphDestroy(COOLINFO FAR *ci, HANDLE hGraph)
{
 	(*ci->lpGraphDestroy)(hGraph);
}

int GraphHandleWM_LBUTTONDOWN(COOLINFO FAR *ci, HANDLE hGraph, POINT pCursor)
{
 	return (int)(*ci->lpGraphHandleWM_LBUTTONDOWN)(hGraph, pCursor);
}

int GraphHandleWM_LBUTTONUP(COOLINFO FAR *ci, HANDLE hGraph, POINT pCursor)
{
 	return (int)(*ci->lpGraphHandleWM_LBUTTONUP)(hGraph, pCursor);
}

int GraphHandleWM_LBUTTONDBLCLK(COOLINFO FAR *ci, HANDLE hGraph, POINT pCursor)
{
 	return (int)(*ci->lpGraphHandleWM_LBUTTONDBLCLK)(hGraph, pCursor);
}

int GraphHandleWM_MOUSEMOVE(COOLINFO FAR *ci, HANDLE hGraph, POINT pCursor)
{
 	return (int)(*ci->lpGraphHandleWM_MOUSEMOVE)(hGraph, pCursor);
}

void GraphSetDblClkScales(COOLINFO FAR *ci, HANDLE hGraph, double sc1,double of1,int mag1,double sc2,double of2, int mag2,WORD wStyle)
{
 	(*ci->lpGraphSetDblClkScales)(hGraph,sc1,of1,mag1,sc2,of2,mag2,wStyle);
}

void GraphSetDblClkNames(COOLINFO FAR *ci, HANDLE hGraph,LPCSTR ept1, LPCSTR epu1, LPCSTR ept2, LPCSTR epu2)
{
 	(*ci->lpGraphSetDblClkNames)(hGraph,ept1,epu1,ept2,epu2);
}

void GetTempName(COOLINFO FAR *ci, LPSTR szThree, LPSTR szFilename)
{
 	(*ci->lpGetTempName)(szThree,szFilename);
} 

void SetWindowType(COOLINFO FAR *ci, int type)
{	
	(*ci->lpSetWindowType)(type);
}   

void WindowFFT(COOLINFO FAR *ci, float far *data, int size, BOOL bStereo)
{
 	(*ci->lpWindowFFT)(data, size, bStereo);
}   

void IWindowFFT(COOLINFO FAR *ci, float far *data, BOOL bStereo)
{
 	(*ci->lpIWindowFFT)(data, bStereo);
}

void FFT(COOLINFO FAR *ci, float far *data, int nn, int isign)
{
 	(*ci->lpFFT)(data,nn,isign,0,nn-1);
}

void SetFFT16bit(COOLINFO FAR *ci, float far *data, int far *in, int iSamples)
{
 	(*ci->lpSetFFT16bit)(data, in, iSamples);
}

void SetFFT8bit(COOLINFO FAR *ci, float far *data, unsigned char far *in, int iSamples)
{
 	(*ci->lpSetFFT8bit)(data, in, iSamples);
}   

void SetStereoFFT16bit(COOLINFO FAR *ci, float far *data, int far *left, int far *right, int iSamples)
{
 	(*ci->lpSetStereoFFT16bit)(data,left,right,iSamples);
}   

void SetStereoFFT8bit(COOLINFO FAR *ci, float far *data, unsigned char far *left, unsigned char far *right, int iSamples)
{
 	(*ci->lpSetStereoFFT8bit)(data,left,right,iSamples);
}   
                
void SetStereoFFT16bitInterleaved(COOLINFO FAR *ci, float FAR *data, int far *in, int iSamples)
{	
	(*ci->lpSetStereoFFT16bitInterleaved)(data, in, iSamples);
}

void SetStereoFFT8bitInterleaved(COOLINFO FAR *ci, float FAR *data, unsigned char far *in, int iSamples)
{
	(*ci->lpSetStereoFFT8bitInterleaved)(data, in, iSamples);
}

void GetStereoFFT16bitInterleaved(COOLINFO FAR *ci, float FAR *data, int far *in, int iSamples, int iOperation)
{
	(*ci->lpGetStereoFFT16bitInterleaved)(data, in, iSamples, iOperation);
}

void GetStereoFFT8bitInterleaved(COOLINFO FAR *ci, float FAR *data, unsigned char far *in, int iSamples, int iOperation)
{
	(*ci->lpGetStereoFFT8bitInterleaved)(data, in, iSamples, iOperation);
}  

void SetXfmVar(COOLINFO FAR *ci, HANDLE hVars, int offset, int length, void far *mem)
{
 	(*ci->lpSetXfmVar)(hVars, offset, length, mem);
}

long CallXfm(COOLINFO FAR *ci, LPCSTR szXfmName, HANDLE hVars, DWORD losamp, DWORD hisamp, BOOL bShowMeter)
{
 	return (long)(*ci->lpCallXfm)(szXfmName,hVars,losamp,hisamp,bShowMeter);
}

HANDLE CreateXfmVars(COOLINFO FAR *ci, LPCSTR szXfmName)
{
 	return (HANDLE)(*ci->lpCreateXfmVars)(szXfmName);
}

int DeleteXfmVars(COOLINFO FAR *ci, LPCSTR szXfmName, HANDLE hXfmVars)
{
 	return (int)(*ci->lpDeleteXfmVars)(szXfmName,hXfmVars);
}
